/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.entity.projectile.AbstractProjectile;
import dev.toma.gunsrpg.sided.ClientSideManager;
import dev.toma.gunsrpg.util.RenderUtils;
import dev.toma.gunsrpg.util.properties.Properties;
import lib.toma.animations.AnimationUtils;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;

public class TracerRenderer<P extends AbstractProjectile>
extends EntityRenderer<P> {
    private static final ResourceLocation TRACER = GunsRPG.makeResource("textures/entity/tracer.png");
    private static final int MAX_BRIGHTNESS = LightTexture.func_228451_a_((int)15, (int)15);

    public TracerRenderer(EntityRendererManager manager) {
        super(manager);
    }

    public ResourceLocation getTextureLocation(P projectile) {
        return TRACER;
    }

    public void render(P projectile, float yaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer typeBuffer, int light) {
        Integer rgb = ((AbstractProjectile)((Object)projectile)).getProperty(Properties.TRACER);
        if (rgb != null && ((AbstractProjectile)((Object)projectile)).field_70173_aa > 0) {
            float r = RenderUtils.red(rgb);
            float g = RenderUtils.green(rgb);
            float b = RenderUtils.blue(rgb);
            float a = 1.0f;
            float x = AnimationUtils.linearInterpolate((float)projectile.func_226277_ct_(), (float)((AbstractProjectile)((Object)projectile)).field_70169_q, partialTicks);
            float y = AnimationUtils.linearInterpolate((float)projectile.func_226278_cu_(), (float)((AbstractProjectile)((Object)projectile)).field_70167_r, partialTicks);
            float z = AnimationUtils.linearInterpolate((float)projectile.func_226281_cx_(), (float)((AbstractProjectile)((Object)projectile)).field_70166_s, partialTicks);
            float sizeScale = 0.2f;
            Vector3d vec1 = projectile.func_213303_ch();
            Vector3d vec2 = vec1.func_178787_e(projectile.func_213322_ci());
            float x1 = (float)vec1.field_72450_a - x;
            float y1 = (float)vec1.field_72448_b - y - 0.1f;
            float z1 = (float)vec1.field_72449_c - z;
            float x2 = sizeScale * (float)(vec2.field_72450_a - (double)x);
            float y2 = sizeScale * (float)(vec2.field_72448_b - (double)y - (double)0.1f);
            float z2 = sizeScale * (float)(vec2.field_72449_c - (double)z);
            MatrixStack.Entry entry = matrix.func_227866_c_();
            Matrix4f pose = entry.func_227870_a_();
            Matrix3f normal = entry.func_227872_b_();
            float scale = ClientSideManager.config.tracerScale;
            boolean nx = false;
            boolean ny = true;
            boolean nz = false;
            IVertexBuilder builder = typeBuffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)TRACER));
            builder.func_227888_a_(pose, x1 - scale, y1 - scale, z1 - scale).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(MAX_BRIGHTNESS).func_227887_a_(normal, (float)nx, (float)ny, (float)nz).func_181675_d();
            builder.func_227888_a_(pose, x1 + scale, y1 + scale, z1 + scale).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(MAX_BRIGHTNESS).func_227887_a_(normal, (float)nx, (float)ny, (float)nz).func_181675_d();
            builder.func_227888_a_(pose, x2 + scale, y2 + scale, z2 + scale).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(MAX_BRIGHTNESS).func_227887_a_(normal, (float)nx, (float)ny, (float)nz).func_181675_d();
            builder.func_227888_a_(pose, x2 - scale, y2 - scale, z2 - scale).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(MAX_BRIGHTNESS).func_227887_a_(normal, (float)nx, (float)ny, (float)nz).func_181675_d();
            builder.func_227888_a_(pose, x1 - scale, y1 + scale, z1 - scale).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(MAX_BRIGHTNESS).func_227887_a_(normal, (float)nx, (float)ny, (float)nz).func_181675_d();
            builder.func_227888_a_(pose, x1 + scale, y1 - scale, z1 + scale).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(MAX_BRIGHTNESS).func_227887_a_(normal, (float)nx, (float)ny, (float)nz).func_181675_d();
            builder.func_227888_a_(pose, x2 + scale, y2 - scale, z2 + scale).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(MAX_BRIGHTNESS).func_227887_a_(normal, (float)nx, (float)ny, (float)nz).func_181675_d();
            builder.func_227888_a_(pose, x2 - scale, y2 + scale, z2 - scale).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(MAX_BRIGHTNESS).func_227887_a_(normal, (float)nx, (float)ny, (float)nz).func_181675_d();
            builder.func_227888_a_(pose, x1 + scale, y1 - scale, z1 + scale).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(MAX_BRIGHTNESS).func_227887_a_(normal, (float)nx, (float)ny, (float)nz).func_181675_d();
            builder.func_227888_a_(pose, x1 - scale, y1 + scale, z1 - scale).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(MAX_BRIGHTNESS).func_227887_a_(normal, (float)nx, (float)ny, (float)nz).func_181675_d();
            builder.func_227888_a_(pose, x2 - scale, y2 + scale, z2 - scale).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(MAX_BRIGHTNESS).func_227887_a_(normal, (float)nx, (float)ny, (float)nz).func_181675_d();
            builder.func_227888_a_(pose, x2 + scale, y2 - scale, z2 + scale).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(MAX_BRIGHTNESS).func_227887_a_(normal, (float)nx, (float)ny, (float)nz).func_181675_d();
            builder.func_227888_a_(pose, x1 + scale, y1 + scale, z1 + scale).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(MAX_BRIGHTNESS).func_227887_a_(normal, (float)nx, (float)ny, (float)nz).func_181675_d();
            builder.func_227888_a_(pose, x1 - scale, y1 - scale, z1 - scale).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(MAX_BRIGHTNESS).func_227887_a_(normal, (float)nx, (float)ny, (float)nz).func_181675_d();
            builder.func_227888_a_(pose, x2 - scale, y2 - scale, z2 - scale).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(MAX_BRIGHTNESS).func_227887_a_(normal, (float)nx, (float)ny, (float)nz).func_181675_d();
            builder.func_227888_a_(pose, x2 + scale, y2 + scale, z2 + scale).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(MAX_BRIGHTNESS).func_227887_a_(normal, (float)nx, (float)ny, (float)nz).func_181675_d();
        }
    }
}

